﻿using System;
using System.Collections.Generic;
using System.Text;

using Thomas_Erdoesi.Game_Analyzer;

namespace Thomas_Erdoesi.Game_Objects
{
    public class GameObjectLocation
    {
        public int x;
        public int y;

        public GameObjectLocation() : this(0,0)
        {
        }

        public GameObjectLocation(int x, int y)
        {
            this.x = x;
            this.y = y;
        }

        public GameObjectLocation ToScreenCoordinates()
        {
            int ScrX = x;
            int ScrY = y;

            while (ScrX < GameConstants.MinCoordX) ScrX += GameConstants.SizeX;
            while (ScrX > GameConstants.MinCoordX) ScrX -= GameConstants.SizeX;
            while (ScrY < GameConstants.MinCoordY) ScrY += GameConstants.SizeY;
            while (ScrY > GameConstants.MinCoordY) ScrY -= GameConstants.SizeY;

            return new GameObjectLocation(ScrX, ScrY);
        }

        public GameObjectDistance GetDistance(GameObjectLocation Location)
        {
            return new GameObjectDistance(this, Location);
        }

        public void Clip()
        {
            if (x < GameConstants.MinCoordX) x += GameConstants.SizeX;
            if (x > GameConstants.MaxCoordX) x -= GameConstants.SizeX;
            if (y < GameConstants.MinCoordY) y += GameConstants.SizeY;
            if (y > GameConstants.MaxCoordY) y -= GameConstants.SizeY;
        }

        public static GameObjectLocation operator +(GameObjectLocation Loc1, GameObjectLocation Loc2)
        {
            return new GameObjectLocation(Loc1.x + Loc2.x, Loc1.y + Loc2.y);
        }

        public static GameObjectLocation operator -(GameObjectLocation Loc1, GameObjectLocation Loc2)
        {
            return new GameObjectLocation(Loc1.x - Loc2.x, Loc1.y - Loc2.y);
        }
    }
}
